// GMSH script to generate the mesh for the 3d hollow sphere
// Documentation: https://gmsh.info/doc/texinfo/gmsh.html
// Design from: CodeAster validation manual (https://code-aster.org/V2/doc/v14/fr/man_v/v4/v4.04.006.pdf)
// Author: Andrea Pavan
// Date: 07/01/2023


//parameters
Ri = 1;		//internal radius
Re = 2;		//external radius
alpha = 30*Pi/180;		//domain angle

surfaceMeshSize = 0.03;		//mesh size at the boundaries


//change geometry kernel
SetFactory("OpenCASCADE");


//-----------------------
//  geometry creation
//-----------------------

Point(1) = {0, 0, 0, surfaceMeshSize};
Point(2) = {Ri, 0, 0, surfaceMeshSize};
Point(3) = {Ri*Cos(alpha), Ri*Sin(alpha), 0, surfaceMeshSize};
Point(4) = {Re*Cos(alpha), Re*Sin(alpha), 0, surfaceMeshSize};
Point(5) = {Re, 0, 0, surfaceMeshSize};

Circle(1) = {2, 1, 3};
Line(2) = {3, 4};
Circle(3) = {4, 1, 5};
Line(4) = {5, 2};

Curve Loop(1) = {1, 2, 3, 4};
Plane Surface(1) = {1};
Extrude {{0, 1, 0}, {0, 0, 0}, -alpha} {
  Curve{1}; Curve{2}; Curve{3}; Curve{4}; 
}
Curve Loop(6) = {9, 11, 12, 7};
Plane Surface(6) = {6};
Surface Loop(1) = {6, 3, 2, 5, 4, 1};
Volume(1) = {1};
